
*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo de la Tasa de Accidentes de Trnsito por cada 1000 vehculos matriculados*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2016 - Accidentes de Trnsito*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        29 de Septiembre del 2017*
* Fecha ltima modificacin:   29 de Septiembre del 2017*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.

*Instrucciones:.
*1.- Descarga la base de datos de Accidentes de Trnsito "2016_Accidentes Trnsito_BDD" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2016_Accidentes Trnsito_BDD".

dataset name ACCIDENTES.
dataset copy 2016_Accidentes Trnsito_BDD.
dataset activate ACCIDENTES.

**********************************************************************************************************************.
*TASA DE ACCIDENTES DE TRNSITO POR CADA DIEZ MIL VEHCULOS A NIVEL PROVINCIAL***.
**********************************************************************************************************************.

***Creando variable nmero de accidentes***.
compute NAT=1.
formats NAT (F5.0).
variable labels NAT 'Nmero de accidentes'.
execute.

***Agregando la base de datos a nivel de provincia***.
dataset declare TASA_ACCIDENTES.
aggregate
  /outfile='TASA_ACCIDENTES'
  /break=PROVINCIA
  /NAT=SUM(NAT).

**Utilizacin de la base de datos agregada***.
dataset activate TASA_ACCIDENTES.

***Preparando la base para el clculo del indicador***.
variable labels NAT 'Nmero de accidentes de trnsito'.
formats NAT (F10.0).
execute.

if (PROVINCIA=1) VEHICULOS=64254.
if (PROVINCIA=2) VEHICULOS=12957.
if (PROVINCIA=3) VEHICULOS=34251.
if (PROVINCIA=4) VEHICULOS=16269.
if (PROVINCIA=5) VEHICULOS=36511.
if (PROVINCIA=6) VEHICULOS=32960.
if (PROVINCIA=7) VEHICULOS=83417.
if (PROVINCIA=8) VEHICULOS=37064.
if (PROVINCIA=9) VEHICULOS=481294.
if (PROVINCIA=10) VEHICULOS=22127.
if (PROVINCIA=11) VEHICULOS=20791.
if (PROVINCIA=12) VEHICULOS=101774.
if (PROVINCIA=13) VEHICULOS=158157.
if (PROVINCIA=14) VEHICULOS=9419.
if (PROVINCIA=15) VEHICULOS=6643.
if (PROVINCIA=16) VEHICULOS=8398.
if (PROVINCIA=17) VEHICULOS=733269.
if (PROVINCIA=18) VEHICULOS=86469.
if (PROVINCIA=19) VEHICULOS=5414.
if (PROVINCIA=20) VEHICULOS=1256.
if (PROVINCIA=21) VEHICULOS=25807.
if (PROVINCIA=22) VEHICULOS=14547.
if (PROVINCIA=23) VEHICULOS=39769.
if (PROVINCIA=24) VEHICULOS=23396.
execute.

variable labels VEHICULOS 'Vehculos Motorizados Matriculados 2016'.
formats VEHICULOS (F10.0).
execute.

compute VEHICULOS_1000=(VEHICULOS/1000).
variable labels VEHICULOS_1000 'Vehculos/1000'.
formats VEHICULOS_1000 (F10.0).
execute.

compute TAT=(NAT/VEHICULOS_1000).
variable labels TAT 'Tasa de accidentes de trnsito por cada 1000 Vehculos Matriculados'.
formats TAT (F5.0).
execute.

***Tabulado: Tasa de Accidentes de Trnsito por Provincias***.
tables
/observation= NAT VEHICULOS_1000 TAT
/table= PROVINCIA BY NAT + VEHICULOS_1000 + TAT
/statistics=sum.
execute.

dataset close TASA_ACCIDENTES.

********************************************************************************************************************.
****TASA DE ACCIDENTES DE TRNSITO POR CADA MIL VEHCULOS A NIVEL NACIONAL***.
********************************************************************************************************************.

*Usando base de datos "2016_Accidentes Trnsito_BDD"**.
dataset activate ACCIDENTES.

compute NACIONAL=1.
variable labels NACIONAL 'Nacional'.
formats NACIONAL (F1.0).
execute.

***Creando variable nmero de accidentes***.
compute NAT=1.
formats NAT (F5.0).
variable labels NAT 'Nmero de accidentes'.
execute.

***Agregando la base de datos a nivel nacional***.
dataset declare TASA_ACCIDENTES_N.
aggregate
  /outfile='TASA_ACCIDENTES_N'
  /break=NACIONAL
  /NAT=SUM(NAT).

**Utilizacin de la base de datos agregada***.
dataset activate TASA_ACCIDENTES_N.

***Preparabdo la base para el clculo del indicador***.
variable labels NAT 'Nmero de accidentes de trnsito'.
formats NAT (F10.0).
execute.

compute VEHICULOS=2056213.
variable labels VEHICULOS 'Vehculos Motorizados Matriculados 2016'.
formats VEHICULOS (F10.0).
execute.

compute VEHICULOS_1000=(VEHICULOS/1000).
variable labels VEHICULOS_1000 'Vehculos/1000'.
formats VEHICULOS_1000 (F10.0).
execute.

compute TAT=(NAT/VEHICULOS_1000).
variable labels TAT 'Tasa de accidentes de trnsito por cada 1000 Vehculos'.
formats TAT (F5.0).
execute.

***Tabulado: Tasa de Accidentes de Trnsito Nacional***.
tables
/observation= NAT VEHICULOS_1000 TAT
/table= NACIONAL BY NAT + VEHICULOS_1000 + TAT
/statistics=sum.
execute.

dataset close TASA_ACCIDENTES_N.










